function [ret,x0,str,ts,xts]=an_ap(t,x,u,flag);
%AN_AP	is the M-file description of the SIMULINK system named AN_AP.
%	The block-diagram can be displayed by typing: AN_AP.
%
%	SYS=AN_AP(T,X,U,FLAG) returns depending on FLAG certain
%	system values given time point, T, current state vector, X,
%	and input vector, U.
%	FLAG is used to indicate the type of output to be returned in SYS.
%
%	Setting FLAG=1 causes AN_AP to return state derivatives, FLAG=2
%	discrete states, FLAG=3 system outputs and FLAG=4 next sample
%	time. For more information and other options see SFUNC.
%
%	Calling AN_AP with a FLAG of zero:
%	[SIZES]=AN_AP([],[],[],0),  returns a vector, SIZES, which
%	contains the sizes of the state vector and other parameters.
%		SIZES(1) number of states
%		SIZES(2) number of discrete states
%		SIZES(3) number of outputs
%		SIZES(4) number of inputs
%		SIZES(5) number of roots (currently unsupported)
%		SIZES(6) direct feedthrough flag
%		SIZES(7) number of sample times
%
%	For the definition of other parameters in SIZES, see SFUNC.
%	See also, TRIM, LINMOD, LINSIM, EULER, RK23, RK45, ADAMS, GEAR.

% Note: This M-file is only used for saving graphical information;
%       after the model is loaded into memory an internal model
%       representation is used.

% the system will take on the name of this mfile:
sys = mfilename;
new_system(sys)
simver(1.3)
if (0 == (nargin + nargout))
     set_param(sys,'Location',[4,42,752,315])
     open_system(sys)
end;
set_param(sys,'algorithm',     'Linear')
set_param(sys,'Start time',    '0.0')
set_param(sys,'Stop time',     '50')
set_param(sys,'Min step size', '0.0001')
set_param(sys,'Max step size', '.01')
set_param(sys,'Relative error','1e-3')
set_param(sys,'Return vars',   '')


%     Subsystem  'sistema '.

new_system([sys,'/','sistema '])
set_param([sys,'/','sistema '],'Location',[250,112,465,237])

add_block('built-in/Transfer Fcn',[sys,'/','sistema /Transfer Fcn'])
set_param([sys,'/','sistema /Transfer Fcn'],...
		'ForeGround',4,...
		'hide name',0,...
		'Numerator','num',...
		'Denominator','den',...
		'position',[115,57,185,93])

add_block('built-in/Inport',[sys,'/','sistema /in_1'])
set_param([sys,'/','sistema /in_1'],...
		'position',[15,65,35,85])

add_block('built-in/Outport',[sys,'/','sistema /out_1'])
set_param([sys,'/','sistema /out_1'],...
		'position',[200,65,220,85])


%     Subsystem  'sistema /delay'.

new_system([sys,'/','sistema /delay'])
set_param([sys,'/','sistema /delay'],'Location',[125,196,380,426])

add_block('built-in/Transport Delay',[sys,'/',['sistema /delay/Transport',13,'Delay']])
set_param([sys,'/',['sistema /delay/Transport',13,'Delay']],...
		'ForeGround',4,...
		'hide name',0,...
		'Delay Time','T',...
		'position',[85,165,125,195])

add_block('built-in/Note',[sys,'/','sistema /delay/1 se T=0'])
set_param([sys,'/','sistema /delay/1 se T=0'],...
		'position',[135,95,140,100])

add_block('built-in/Switch',[sys,'/','sistema /delay/Switch'])
set_param([sys,'/','sistema /delay/Switch'],...
		'Threshold','.5',...
		'position',[180,104,210,136])


%     Subsystem  'sistema /delay/control'.

new_system([sys,'/','sistema /delay/control'])
set_param([sys,'/','sistema /delay/control'],'Location',[65,181,260,331])

add_block('built-in/Constant',[sys,'/','sistema /delay/control/T'])
set_param([sys,'/','sistema /delay/control/T'],...
		'Value','T',...
		'position',[20,45,40,65])

add_block('built-in/Constant',[sys,'/','sistema /delay/control/zero'])
set_param([sys,'/','sistema /delay/control/zero'],...
		'Value','0',...
		'position',[20,95,40,115])

add_block('built-in/Relational Operator',[sys,'/','sistema /delay/control/uguale'])
set_param([sys,'/','sistema /delay/control/uguale'],...
		'Operator','==',...
		'position',[105,53,135,77])

add_block('built-in/Outport',[sys,'/','sistema /delay/control/out_1'])
set_param([sys,'/','sistema /delay/control/out_1'],...
		'position',[200,55,220,75])
add_line([sys,'/','sistema /delay/control'],[45,105;65,105;65,70;100,70])
add_line([sys,'/','sistema /delay/control'],[45,55;100,60])
add_line([sys,'/','sistema /delay/control'],[140,65;195,65])


%     Finished composite block 'sistema /delay/control'.

set_param([sys,'/','sistema /delay/control'],...
		'position',[70,105,95,135])

add_block('built-in/Outport',[sys,'/','sistema /delay/out_1'])
set_param([sys,'/','sistema /delay/out_1'],...
		'position',[240,110,260,130])

add_block('built-in/Inport',[sys,'/','sistema /delay/in_1'])
set_param([sys,'/','sistema /delay/in_1'],...
		'position',[15,110,35,130])
add_line([sys,'/','sistema /delay'],[130,180;160,180;160,130;175,130])
add_line([sys,'/','sistema /delay'],[40,120;50,120;50,60;165,60;175,110])
add_line([sys,'/','sistema /delay'],[50,120;50,180;80,180])
add_line([sys,'/','sistema /delay'],[215,120;235,120])
add_line([sys,'/','sistema /delay'],[100,120;175,120])


%     Finished composite block 'sistema /delay'.

set_param([sys,'/','sistema /delay'],...
		'position',[70,56,90,94])
add_line([sys,'/','sistema '],[95,75;110,75])
add_line([sys,'/','sistema '],[40,75;65,75])
add_line([sys,'/','sistema '],[190,75;195,75])
set_param([sys,'/','sistema '],...
		'Mask Display','sistema',...
		'Mask Dialogue','eval(''blocca'')')


%     Finished composite block 'sistema '.

set_param([sys,'/','sistema '],...
		'ForeGround',4,...
		'hide name',0,...
		'Font Size',11,...
		'position',[250,49,360,101])


%     Subsystem  'segnali'.

new_system([sys,'/','segnali'])
set_param([sys,'/','segnali'],'Location',[152,255,407,425])


%     Subsystem  ['segnali/onda',13,'quadra'].

new_system([sys,'/',['segnali/onda',13,'quadra']])
set_param([sys,'/',['segnali/onda',13,'quadra']],'Location',[158,441,759,682])

add_block('built-in/Outport',[sys,'/',['segnali/onda',13,'quadra/out_1']])
set_param([sys,'/',['segnali/onda',13,'quadra/out_1']],...
		'hide name',0,...
		'position',[560,105,580,125])

add_block('built-in/Gain',[sys,'/',['segnali/onda',13,'quadra/Gain']])
set_param([sys,'/',['segnali/onda',13,'quadra/Gain']],...
		'hide name',0,...
		'Gain','ht',...
		'position',[510,102,535,128])

add_block('built-in/Product',[sys,'/',['segnali/onda',13,'quadra/Product']])
set_param([sys,'/',['segnali/onda',13,'quadra/Product']],...
		'hide name',0,...
		'position',[455,105,480,125])

add_block('built-in/Logical Operator',[sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator1']],...
		'Operator','NOT',...
		'Number of Input Ports','1',...
		'position',[355,38,385,62])

add_block('built-in/Logical Operator',[sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator']])
set_param([sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator']],...
		'Operator','XOR',...
		'position',[285,38,315,62])

add_block('built-in/Constant',[sys,'/',['segnali/onda',13,'quadra/Constant1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Constant1']],...
		'Value','stt',...
		'position',[295,149,320,171])

add_block('built-in/Clock',[sys,'/',['segnali/onda',13,'quadra/Clock1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Clock1']],...
		'hide name',0,...
		'position',[295,100,315,120])

add_block('built-in/Relational Operator',[sys,'/',['segnali/onda',13,'quadra/Relational',13,'operator']])
set_param([sys,'/',['segnali/onda',13,'quadra/Relational',13,'operator']],...
		'hide name',0,...
		'position',[370,102,400,133])

add_block('built-in/Sum',[sys,'/',['segnali/onda',13,'quadra/Sum1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Sum1']],...
		'hide name',0,...
		'inputs','+-',...
		'position',[130,120,150,140])

add_block('built-in/Sum',[sys,'/',['segnali/onda',13,'quadra/Sum']])
set_param([sys,'/',['segnali/onda',13,'quadra/Sum']],...
		'hide name',0,...
		'inputs','+-',...
		'position',[135,35,155,55])

add_block('built-in/Constant',[sys,'/',['segnali/onda',13,'quadra/Constant']])
set_param([sys,'/',['segnali/onda',13,'quadra/Constant']],...
		'position',[25,30,45,50])

add_block('built-in/Unit Delay',[sys,'/',['segnali/onda',13,'quadra/Unit Delay']])
set_param([sys,'/',['segnali/onda',13,'quadra/Unit Delay']],...
		'orientation',2,...
		'Sample time','[Ts,st1]',...
		'position',[145,75,195,95])

add_block('built-in/Unit Delay',[sys,'/',['segnali/onda',13,'quadra/Unit Delay1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Unit Delay1']],...
		'orientation',2,...
		'Sample time','[Ts,st2]',...
		'x0','ini',...
		'position',[140,165,190,185])
add_line([sys,'/',['segnali/onda',13,'quadra']],[390,50;430,50;430,110;450,110])
add_line([sys,'/',['segnali/onda',13,'quadra']],[320,50;350,50])
add_line([sys,'/',['segnali/onda',13,'quadra']],[325,160;345,160;345,125;365,125])
add_line([sys,'/',['segnali/onda',13,'quadra']],[540,115;555,115])
add_line([sys,'/',['segnali/onda',13,'quadra']],[485,115;505,115])
add_line([sys,'/',['segnali/onda',13,'quadra']],[405,120;450,120])
add_line([sys,'/',['segnali/onda',13,'quadra']],[320,110;365,110])
add_line([sys,'/',['segnali/onda',13,'quadra']],[140,85;105,85;105,50;130,50])
add_line([sys,'/',['segnali/onda',13,'quadra']],[160,45;230,45;230,85;200,85])
add_line([sys,'/',['segnali/onda',13,'quadra']],[50,40;130,40])
add_line([sys,'/',['segnali/onda',13,'quadra']],[155,130;210,130;210,175;195,175])
add_line([sys,'/',['segnali/onda',13,'quadra']],[135,175;100,175;100,135;125,135])
add_line([sys,'/',['segnali/onda',13,'quadra']],[50,40;70,40;70,125;125,125])
add_line([sys,'/',['segnali/onda',13,'quadra']],[160,45;280,45])
add_line([sys,'/',['segnali/onda',13,'quadra']],[155,130;245,130;245,55;280,55])
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Display','plot(0,0,100,100,[90,75,75,60,60,35,35,20,20,10],[20,20,80,80,20,20,80,80,20,20])',...
		'Mask Type','Pulse Generator')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Dialogue','Pulse Generator.|Pulse period (secs):|Pulse width:|Pulse height:|Pulse start time:')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Translate','Ts=@1; du=@2; ht=@3; stt=@4; ini=ones(length(ht),1); st1=rem(stt,Ts); st2=rem(stt+du,Ts);if(Ts<=1.2*du),ini=zeros(length(ht),1);end;')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Help','Pulse generator which ensures pulse\ntransitions are hit. Provides a vector of pulses when the height is entered as a vector.\nUnmask to see how it works.')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Entries','2\/1\/1\/0\/')


%     Finished composite block ['segnali/onda',13,'quadra'].

set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'ForeGround',3,...
		'position',[195,53,230,87])

add_block('built-in/Sine Wave',[sys,'/','segnali/sinusoide'])
set_param([sys,'/','segnali/sinusoide'],...
		'ForeGround',3,...
		'position',[40,48,75,82])

add_block('built-in/Step Fcn',[sys,'/','segnali/scalino'])
set_param([sys,'/','segnali/scalino'],...
		'ForeGround',3,...
		'Time','0',...
		'position',[120,49,150,81])


%     Finished composite block 'segnali'.

set_param([sys,'/','segnali'],...
		'ForeGround',3,...
		'position',[45,30,75,82])


%     Subsystem  'connessioni'.

new_system([sys,'/','connessioni'])
set_param([sys,'/','connessioni'],'Location',[350,85,605,255])

add_block('built-in/Mux',[sys,'/','connessioni/Mux'])
set_param([sys,'/','connessioni/Mux'],...
		'hide name',0,...
		'inputs','2',...
		'position',[110,40,150,75])

add_block('built-in/Sum',[sys,'/','connessioni/somma'])
set_param([sys,'/','connessioni/somma'],...
		'hide name',0,...
		'inputs','+-',...
		'position',[120,105,145,145])


%     Finished composite block 'connessioni'.

set_param([sys,'/','connessioni'],...
		'position',[45,124,75,176])


%     Subsystem  'approssimante'.

new_system([sys,'/','approssimante'])
set_param([sys,'/','approssimante'],'Location',[118,232,623,329])


%     Subsystem  'approssimante/f.d.t.'.

new_system([sys,'/','approssimante/f.d.t.'])
set_param([sys,'/','approssimante/f.d.t.'],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/','approssimante/f.d.t./assegna'])
set_param([sys,'/','approssimante/f.d.t./assegna'],...
		'position',[95,45,100,50])
set_param([sys,'/','approssimante/f.d.t.'],...
		'Mask Display','assegnamento f.d.t.',...
		'Mask Type','assegnamento f.d.t.',...
		'Mask Dialogue','eval(''ass_appr'')')


%     Finished composite block 'approssimante/f.d.t.'.

set_param([sys,'/','approssimante/f.d.t.'],...
		'ForeGround',2,...
		'hide name',0,...
		'position',[25,20,175,56])


%     Subsystem  'approssimante/diagrammi'.

new_system([sys,'/','approssimante/diagrammi'])
set_param([sys,'/','approssimante/diagrammi'],'Location',[33,236,275,329])


%     Subsystem  'approssimante/diagrammi/Subsystem2'.

new_system([sys,'/','approssimante/diagrammi/Subsystem2'])
set_param([sys,'/','approssimante/diagrammi/Subsystem2'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','approssimante/diagrammi/Subsystem2/bode'])
set_param([sys,'/','approssimante/diagrammi/Subsystem2/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','approssimante/diagrammi/Subsystem2'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_app'')')


%     Finished composite block 'approssimante/diagrammi/Subsystem2'.

set_param([sys,'/','approssimante/diagrammi/Subsystem2'],...
		'ForeGround',2,...
		'hide name',0,...
		'position',[120,35,175,75])


%     Subsystem  'approssimante/diagrammi/Subsystem1'.

new_system([sys,'/','approssimante/diagrammi/Subsystem1'])
set_param([sys,'/','approssimante/diagrammi/Subsystem1'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','approssimante/diagrammi/Subsystem1/bode'])
set_param([sys,'/','approssimante/diagrammi/Subsystem1/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','approssimante/diagrammi/Subsystem1'],...
		'Mask Display','Nyquist',...
		'Mask Dialogue','eval(''nyq_appr'')')


%     Finished composite block 'approssimante/diagrammi/Subsystem1'.

set_param([sys,'/','approssimante/diagrammi/Subsystem1'],...
		'ForeGround',2,...
		'hide name',0,...
		'position',[45,35,100,75])
set_param([sys,'/','approssimante/diagrammi'],...
		'Mask Display','diagrammi\n  \n (Bode e Nyquist)')


%     Finished composite block 'approssimante/diagrammi'.

set_param([sys,'/','approssimante/diagrammi'],...
		'ForeGround',2,...
		'hide name',0,...
		'position',[215,10,335,66])


%     Subsystem  ['approssimante/singolarita'' e guadagno'].

new_system([sys,'/',['approssimante/singolarita'' e guadagno']])
set_param([sys,'/',['approssimante/singolarita'' e guadagno']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['approssimante/singolarita'' e guadagno/assegna']])
set_param([sys,'/',['approssimante/singolarita'' e guadagno/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['approssimante/singolarita'' e guadagno']],...
		'Mask Display','singolarit,\n guadagno e ritardo',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_app'')')


%     Finished composite block ['approssimante/singolarita'' e guadagno'].

set_param([sys,'/',['approssimante/singolarita'' e guadagno']],...
		'ForeGround',2,...
		'hide name',0,...
		'position',[360,15,495,66])
set_param([sys,'/','approssimante'],...
		'Mask Display','approssimante')


%     Finished composite block 'approssimante'.

set_param([sys,'/','approssimante'],...
		'ForeGround',2,...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[400,215,525,260])


%     Subsystem  'sistema'.

new_system([sys,'/','sistema'])
set_param([sys,'/','sistema'],'Location',[110,361,620,460])


%     Subsystem  'sistema/f.d.t.'.

new_system([sys,'/','sistema/f.d.t.'])
set_param([sys,'/','sistema/f.d.t.'],'Location',[10,269,185,379])

add_block('built-in/Note',[sys,'/','sistema/f.d.t./assegna'])
set_param([sys,'/','sistema/f.d.t./assegna'],...
		'position',[95,45,100,50])
set_param([sys,'/','sistema/f.d.t.'],...
		'Mask Display','assegnamento f.d.t.',...
		'Mask Type','assegnamento f.d.t.',...
		'Mask Dialogue','eval(''ass_sis'')')


%     Finished composite block 'sistema/f.d.t.'.

set_param([sys,'/','sistema/f.d.t.'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[20,30,165,76])


%     Subsystem  'sistema/diagrammi'.

new_system([sys,'/','sistema/diagrammi'])
set_param([sys,'/','sistema/diagrammi'],'Location',[33,236,275,329])


%     Subsystem  'sistema/diagrammi/Nyquist'.

new_system([sys,'/','sistema/diagrammi/Nyquist'])
set_param([sys,'/','sistema/diagrammi/Nyquist'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','sistema/diagrammi/Nyquist/bode'])
set_param([sys,'/','sistema/diagrammi/Nyquist/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','sistema/diagrammi/Nyquist'],...
		'Mask Display','Nyquist',...
		'Mask Dialogue','eval(''nyq_sis'')')


%     Finished composite block 'sistema/diagrammi/Nyquist'.

set_param([sys,'/','sistema/diagrammi/Nyquist'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[45,35,100,75])


%     Subsystem  'sistema/diagrammi/Bode'.

new_system([sys,'/','sistema/diagrammi/Bode'])
set_param([sys,'/','sistema/diagrammi/Bode'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','sistema/diagrammi/Bode/bode'])
set_param([sys,'/','sistema/diagrammi/Bode/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','sistema/diagrammi/Bode'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_sis'')')


%     Finished composite block 'sistema/diagrammi/Bode'.

set_param([sys,'/','sistema/diagrammi/Bode'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[135,35,190,75])
set_param([sys,'/','sistema/diagrammi'],...
		'Mask Display','diagrammi\n  \n (Bode e Nyquist)')


%     Finished composite block 'sistema/diagrammi'.

set_param([sys,'/','sistema/diagrammi'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[205,15,335,81])


%     Subsystem  ['sistema/singolarita'' e guadagno'].

new_system([sys,'/',['sistema/singolarita'' e guadagno']])
set_param([sys,'/',['sistema/singolarita'' e guadagno']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['sistema/singolarita'' e guadagno/assegna']])
set_param([sys,'/',['sistema/singolarita'' e guadagno/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['sistema/singolarita'' e guadagno']],...
		'Mask Display','singolarit,\n guadagno e ritardo',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_s'')')


%     Finished composite block ['sistema/singolarita'' e guadagno'].

set_param([sys,'/',['sistema/singolarita'' e guadagno']],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[365,25,505,76])
set_param([sys,'/','sistema'],...
		'Mask Display','sistema')


%     Finished composite block 'sistema'.

set_param([sys,'/','sistema'],...
		'ForeGround',4,...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[100,210,220,255])


%     Subsystem  'approssimante '.

new_system([sys,'/','approssimante '])
set_param([sys,'/','approssimante '],'Location',[250,112,465,237])

add_block('built-in/Transport Delay',[sys,'/',['approssimante /Transport',13,'Delay']])
set_param([sys,'/',['approssimante /Transport',13,'Delay']],...
		'ForeGround',2,...
		'hide name',0,...
		'Delay Time','T_appr',...
		'position',[55,60,95,90])

add_block('built-in/Transfer Fcn',[sys,'/','approssimante /Transfer Fcn'])
set_param([sys,'/','approssimante /Transfer Fcn'],...
		'ForeGround',2,...
		'hide name',0,...
		'Numerator','num_appr',...
		'Denominator','den_appr',...
		'position',[115,57,185,93])

add_block('built-in/Inport',[sys,'/','approssimante /in_1'])
set_param([sys,'/','approssimante /in_1'],...
		'position',[15,65,35,85])

add_block('built-in/Outport',[sys,'/','approssimante /out_1'])
set_param([sys,'/','approssimante /out_1'],...
		'position',[200,65,220,85])
add_line([sys,'/','approssimante '],[100,75;110,75])
add_line([sys,'/','approssimante '],[40,75;50,75])
add_line([sys,'/','approssimante '],[190,75;195,75])
set_param([sys,'/','approssimante '],...
		'Mask Display','approssimante',...
		'Mask Dialogue','eval(''blocca'')')


%     Finished composite block 'approssimante '.

set_param([sys,'/','approssimante '],...
		'ForeGround',2,...
		'hide name',0,...
		'Font Size',11,...
		'position',[245,135,365,185])


%     Subsystem  'grafico'.

new_system([sys,'/','grafico'])
set_param([sys,'/','grafico'],'Location',[4,61,278,254])

add_block('built-in/Inport',[sys,'/','grafico/x'])
set_param([sys,'/','grafico/x'],...
		'position',[65,55,85,75])

add_block('built-in/S-Function',[sys,'/',['grafico/S-function',13,'M-file which plots',13,'lines',13,'']])
set_param([sys,'/',['grafico/S-function',13,'M-file which plots',13,'lines',13,'']],...
		'function name','sfunyst',...
		'parameters','ax, color, npts, dt',...
		'position',[130,55,180,75])
add_line([sys,'/','grafico'],[90,65;125,65])
set_param([sys,'/','grafico'],...
		'Mask Display','plot(0,0,100,100,[83,76,63,52,42,38,28,16,11,84,11,11,11,90,90,11],[75,58,47,54,72,80,84,74,65,65,65,90,40,40,90,90])',...
		'Mask Type','Storage scope.')
set_param([sys,'/','grafico'],...
		'Mask Dialogue','Storage scope using MATLAB graph window.\nEnter plotting ranges and line type.|Initial Time Range:|Initial y-min:|Initial y-max:|Storage pts.:|Line type (rgbw-.:xo):')
set_param([sys,'/','grafico'],...
		'Mask Translate','npts = @4; color = @5; ax = [0, @1, @2, @3]; dt=-1;')
set_param([sys,'/','grafico'],...
		'Mask Help','This block uses a MATLAB figure window to plot the input signal.  The graph limits are automatically scaled to the min and max values of the signal stored in the scope''s signal buffer.  Line type must be in quotes.  See the M-file sfunyst.m.')
set_param([sys,'/','grafico'],...
		'Mask Entries','10\/-10\/10\/20000\/''y-/b-/c-./w:/m*/ro/b+''\/')


%     Finished composite block 'grafico'.

set_param([sys,'/','grafico'],...
		'ForeGround',5,...
		'hide name',0,...
		'position',[465,48,505,102])


%     Subsystem  'help'.

new_system([sys,'/','help'])
set_param([sys,'/','help'],'Location',[265,239,780,449])

add_block('built-in/Note',[sys,'/','help/- il calcolo delle singolarit (poli e zeri), del guadagno e del ritardo della f.d.t.  '])
set_param([sys,'/','help/- il calcolo delle singolarit (poli e zeri), del guadagno e del ritardo della f.d.t.  '],...
		'position',[250,155,255,160])

add_block('built-in/Note',[sys,'/',['help/- l''inserimento della funzione di trasferimento']])
set_param([sys,'/',['help/- l''inserimento della funzione di trasferimento']],...
		'position',[150,75,155,80])

add_block('built-in/Note',[sys,'/',['help/- l''ottenimento dei diagrammi di Bode e di Nyquist']])
set_param([sys,'/',['help/- l''ottenimento dei diagrammi di Bode e di Nyquist']],...
		'position',[165,110,170,115])

add_block('built-in/Note',[sys,'/',['help/ i blocchi con l''ombreggiatura consentono              ']])
set_param([sys,'/',['help/ i blocchi con l''ombreggiatura consentono              ']],...
		'position',[170,35,175,40])
set_param([sys,'/','help'],...
		'Mask Display','?')


%     Finished composite block 'help'.

set_param([sys,'/','help'],...
		'hide name',0,...
		'Font Size',20,...
		'Drop Shadow',4,...
		'position',[642,65,690,112])
add_line(sys,[365,75;460,75])

drawnow

% Return any arguments.
if (nargin | nargout)
	% Must use feval here to access system in memory
	if (nargin > 3)
		if (flag == 0)
			eval(['[ret,x0,str,ts,xts]=',sys,'(t,x,u,flag);'])
		else
			eval(['ret =', sys,'(t,x,u,flag);'])
		end
	else
		[ret,x0,str,ts,xts] = feval(sys);
	end
else
	drawnow % Flash up the model and execute load callback
end
