function [ret,x0,str,ts,xts]=an_ch(t,x,u,flag);
%AN_CH	is the M-file description of the SIMULINK system named AN_CH.
%	The block-diagram can be displayed by typing: AN_CH.
%
%	SYS=AN_CH(T,X,U,FLAG) returns depending on FLAG certain
%	system values given time point, T, current state vector, X,
%	and input vector, U.
%	FLAG is used to indicate the type of output to be returned in SYS.
%
%	Setting FLAG=1 causes AN_CH to return state derivatives, FLAG=2
%	discrete states, FLAG=3 system outputs and FLAG=4 next sample
%	time. For more information and other options see SFUNC.
%
%	Calling AN_CH with a FLAG of zero:
%	[SIZES]=AN_CH([],[],[],0),  returns a vector, SIZES, which
%	contains the sizes of the state vector and other parameters.
%		SIZES(1) number of states
%		SIZES(2) number of discrete states
%		SIZES(3) number of outputs
%		SIZES(4) number of inputs
%		SIZES(5) number of roots (currently unsupported)
%		SIZES(6) direct feedthrough flag
%		SIZES(7) number of sample times
%
%	For the definition of other parameters in SIZES, see SFUNC.
%	See also, TRIM, LINMOD, LINSIM, EULER, RK23, RK45, ADAMS, GEAR.

% Note: This M-file is only used for saving graphical information;
%       after the model is loaded into memory an internal model
%       representation is used.

% the system will take on the name of this mfile:
sys = mfilename;
new_system(sys)
simver(1.3)
if (0 == (nargin + nargout))
     set_param(sys,'Location',[4,44,827,349])
     open_system(sys)
end;
set_param(sys,'algorithm',     'Linear')
set_param(sys,'Start time',    '0.0')
set_param(sys,'Stop time',     '20')
set_param(sys,'Min step size', '0.0001')
set_param(sys,'Max step size', '1')
set_param(sys,'Relative error','1e-3')
set_param(sys,'Return vars',   '')

add_block('built-in/Note',[sys,'/','d'])
set_param([sys,'/','d'],...
		'ForeGround',3,...
		'Font Weight','bold',...
		'position',[550,45,555,50])


%     Subsystem  'grafico'.

new_system([sys,'/','grafico'])
set_param([sys,'/','grafico'],'Location',[4,61,278,254])

add_block('built-in/S-Function',[sys,'/',['grafico/S-function',13,'M-file which plots',13,'lines',13,'']])
set_param([sys,'/',['grafico/S-function',13,'M-file which plots',13,'lines',13,'']],...
		'function name','sfunyst',...
		'parameters','ax, color, npts, dt',...
		'position',[130,55,180,75])

add_block('built-in/Inport',[sys,'/','grafico/x'])
set_param([sys,'/','grafico/x'],...
		'position',[65,55,85,75])
add_line([sys,'/','grafico'],[90,65;125,65])
set_param([sys,'/','grafico'],...
		'Mask Display','plot(0,0,100,100,[83,76,63,52,42,38,28,16,11,84,11,11,11,90,90,11],[75,58,47,54,72,80,84,74,65,65,65,90,40,40,90,90])',...
		'Mask Type','Storage scope.')
set_param([sys,'/','grafico'],...
		'Mask Dialogue','Storage scope using MATLAB graph window.\nEnter plotting ranges and line type.|Initial Time Range:|Initial y-min:|Initial y-max:|Storage pts.:|Line type (rgbw-.:xo):')
set_param([sys,'/','grafico'],...
		'Mask Translate','npts = @4; color = @5; ax = [0, @1, @2, @3]; dt=-1;')
set_param([sys,'/','grafico'],...
		'Mask Help','This block uses a MATLAB figure window to plot the input signal.  The graph limits are automatically scaled to the min and max values of the signal stored in the scope''s signal buffer.  Line type must be in quotes.  See the M-file sfunyst.m.')
set_param([sys,'/','grafico'],...
		'Mask Entries','10\/-10\/10\/2000\/''y-/g--/c-./w:/m*/ro/b+''\/')


%     Finished composite block 'grafico'.

set_param([sys,'/','grafico'],...
		'ForeGround',5,...
		'position',[705,72,740,118])

add_block('built-in/Sum',[sys,'/','differenza'])
set_param([sys,'/','differenza'],...
		'hide name',0,...
		'Font Size',11,...
		'inputs','+-',...
		'position',[110,84,125,111])

add_block('built-in/Note',[sys,'/','y*'])
set_param([sys,'/','y*'],...
		'ForeGround',3,...
		'Font Weight','bold',...
		'position',[90,55,95,60])


%     Subsystem  'sistema'.

new_system([sys,'/','sistema'])
set_param([sys,'/','sistema'],'Location',[55,185,568,276])


%     Subsystem  'sistema/f.d.t.'.

new_system([sys,'/','sistema/f.d.t.'])
set_param([sys,'/','sistema/f.d.t.'],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/','sistema/f.d.t./assegna'])
set_param([sys,'/','sistema/f.d.t./assegna'],...
		'position',[95,45,100,50])
set_param([sys,'/','sistema/f.d.t.'],...
		'Mask Display','inserimento\n f.d.t.',...
		'Mask Type','assegnamento sistema',...
		'Mask Dialogue','eval(''ass1_sis'')')


%     Finished composite block 'sistema/f.d.t.'.

set_param([sys,'/','sistema/f.d.t.'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[50,15,150,56])


%     Subsystem  'sistema/grafici'.

new_system([sys,'/','sistema/grafici'])
set_param([sys,'/','sistema/grafici'],'Location',[174,316,416,409])


%     Subsystem  'sistema/grafici/Subsystem1'.

new_system([sys,'/','sistema/grafici/Subsystem1'])
set_param([sys,'/','sistema/grafici/Subsystem1'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','sistema/grafici/Subsystem1/bode'])
set_param([sys,'/','sistema/grafici/Subsystem1/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','sistema/grafici/Subsystem1'],...
		'Mask Display','Nyquist',...
		'Mask Dialogue','eval(''nyq_sis'')')


%     Finished composite block 'sistema/grafici/Subsystem1'.

set_param([sys,'/','sistema/grafici/Subsystem1'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[45,35,100,75])


%     Subsystem  'sistema/grafici/Subsystem2'.

new_system([sys,'/','sistema/grafici/Subsystem2'])
set_param([sys,'/','sistema/grafici/Subsystem2'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','sistema/grafici/Subsystem2/bode'])
set_param([sys,'/','sistema/grafici/Subsystem2/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','sistema/grafici/Subsystem2'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_sis'')')


%     Finished composite block 'sistema/grafici/Subsystem2'.

set_param([sys,'/','sistema/grafici/Subsystem2'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[120,35,175,75])
set_param([sys,'/','sistema/grafici'],...
		'Mask Display','grafici\n  \n (Bode e Nyquist)')


%     Finished composite block 'sistema/grafici'.

set_param([sys,'/','sistema/grafici'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[215,10,325,62])


%     Subsystem  ['sistema/singolarita'' e guadagno'].

new_system([sys,'/',['sistema/singolarita'' e guadagno']])
set_param([sys,'/',['sistema/singolarita'' e guadagno']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['sistema/singolarita'' e guadagno/assegna']])
set_param([sys,'/',['sistema/singolarita'' e guadagno/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['sistema/singolarita'' e guadagno']],...
		'Mask Display','singolarit,\n guadagno e ritardo',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_s'')')


%     Finished composite block ['sistema/singolarita'' e guadagno'].

set_param([sys,'/',['sistema/singolarita'' e guadagno']],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[360,15,495,66])
set_param([sys,'/','sistema'],...
		'Mask Display','sistema')


%     Finished composite block 'sistema'.

set_param([sys,'/','sistema'],...
		'ForeGround',4,...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[25,235,115,280])


%     Subsystem  'controllore'.

new_system([sys,'/','controllore'])
set_param([sys,'/','controllore'],'Location',[4,220,493,315])


%     Subsystem  'controllore/f.d.t.'.

new_system([sys,'/','controllore/f.d.t.'])
set_param([sys,'/','controllore/f.d.t.'],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/','controllore/f.d.t./assegna'])
set_param([sys,'/','controllore/f.d.t./assegna'],...
		'position',[95,45,100,50])
set_param([sys,'/','controllore/f.d.t.'],...
		'Mask Display','inserimento f.d.t.',...
		'Mask Type','assegnamento controllore',...
		'Mask Dialogue','eval(''ass_c'')')


%     Finished composite block 'controllore/f.d.t.'.

set_param([sys,'/','controllore/f.d.t.'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[15,30,140,81])


%     Subsystem  'controllore/diagrammi'.

new_system([sys,'/','controllore/diagrammi'])
set_param([sys,'/','controllore/diagrammi'],'Location',[33,236,275,329])


%     Subsystem  'controllore/diagrammi/Subsystem1'.

new_system([sys,'/','controllore/diagrammi/Subsystem1'])
set_param([sys,'/','controllore/diagrammi/Subsystem1'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','controllore/diagrammi/Subsystem1/bode'])
set_param([sys,'/','controllore/diagrammi/Subsystem1/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','controllore/diagrammi/Subsystem1'],...
		'Mask Display','Nyquist',...
		'Mask Dialogue','eval(''nyq_c'')')


%     Finished composite block 'controllore/diagrammi/Subsystem1'.

set_param([sys,'/','controllore/diagrammi/Subsystem1'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[45,35,100,75])


%     Subsystem  'controllore/diagrammi/Subsystem2'.

new_system([sys,'/','controllore/diagrammi/Subsystem2'])
set_param([sys,'/','controllore/diagrammi/Subsystem2'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','controllore/diagrammi/Subsystem2/bode'])
set_param([sys,'/','controllore/diagrammi/Subsystem2/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','controllore/diagrammi/Subsystem2'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_c'')')


%     Finished composite block 'controllore/diagrammi/Subsystem2'.

set_param([sys,'/','controllore/diagrammi/Subsystem2'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[120,35,175,75])
set_param([sys,'/','controllore/diagrammi'],...
		'Mask Display','diagrammi\n  \n (Bode e Nyquist)')


%     Finished composite block 'controllore/diagrammi'.

set_param([sys,'/','controllore/diagrammi'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[160,35,270,87])


%     Subsystem  ['controllore/singolarita'' e guadagno'].

new_system([sys,'/',['controllore/singolarita'' e guadagno']])
set_param([sys,'/',['controllore/singolarita'' e guadagno']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['controllore/singolarita'' e guadagno/assegna']])
set_param([sys,'/',['controllore/singolarita'' e guadagno/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['controllore/singolarita'' e guadagno']],...
		'Mask Display','singolarit e guadagno',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_c'')')


%     Finished composite block ['controllore/singolarita'' e guadagno'].

set_param([sys,'/',['controllore/singolarita'' e guadagno']],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[300,35,440,86])
set_param([sys,'/','controllore'],...
		'Mask Display','controllore')


%     Finished composite block 'controllore'.

set_param([sys,'/','controllore'],...
		'ForeGround',6,...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[190,235,290,280])


%     Subsystem  'anello aperto'.

new_system([sys,'/','anello aperto'])
set_param([sys,'/','anello aperto'],'Location',[79,202,569,290])


%     Subsystem  ['anello aperto/singolarita'' e guadagno'].

new_system([sys,'/',['anello aperto/singolarita'' e guadagno']])
set_param([sys,'/',['anello aperto/singolarita'' e guadagno']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['anello aperto/singolarita'' e guadagno/assegna']])
set_param([sys,'/',['anello aperto/singolarita'' e guadagno/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['anello aperto/singolarita'' e guadagno']],...
		'Mask Display','singolarit,\n guadagno e ritardo',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_tot'')')


%     Finished composite block ['anello aperto/singolarita'' e guadagno'].

set_param([sys,'/',['anello aperto/singolarita'' e guadagno']],...
		'hide name',0,...
		'position',[270,20,415,71])


%     Subsystem  'anello aperto/diagrammi'.

new_system([sys,'/','anello aperto/diagrammi'])
set_param([sys,'/','anello aperto/diagrammi'],'Location',[4,42,519,157])


%     Subsystem  'anello aperto/diagrammi/Bode'.

new_system([sys,'/','anello aperto/diagrammi/Bode'])
set_param([sys,'/','anello aperto/diagrammi/Bode'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','anello aperto/diagrammi/Bode/bode'])
set_param([sys,'/','anello aperto/diagrammi/Bode/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','anello aperto/diagrammi/Bode'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_tot'')')


%     Finished composite block 'anello aperto/diagrammi/Bode'.

set_param([sys,'/','anello aperto/diagrammi/Bode'],...
		'hide name',0,...
		'position',[70,55,165,100])


%     Subsystem  'anello aperto/diagrammi/Nyquist'.

new_system([sys,'/','anello aperto/diagrammi/Nyquist'])
set_param([sys,'/','anello aperto/diagrammi/Nyquist'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','anello aperto/diagrammi/Nyquist/bode'])
set_param([sys,'/','anello aperto/diagrammi/Nyquist/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','anello aperto/diagrammi/Nyquist'],...
		'Mask Display','Nyquist',...
		'Mask Dialogue','eval(''nyq_tot'')')


%     Finished composite block 'anello aperto/diagrammi/Nyquist'.

set_param([sys,'/','anello aperto/diagrammi/Nyquist'],...
		'hide name',0,...
		'position',[195,55,290,100])
set_param([sys,'/','anello aperto/diagrammi'],...
		'Mask Display','diagrammi\n  \n (Bode e Nyquist)')


%     Finished composite block 'anello aperto/diagrammi'.

set_param([sys,'/','anello aperto/diagrammi'],...
		'hide name',0,...
		'position',[57,25,180,71])
set_param([sys,'/','anello aperto'],...
		'Mask Display','analisi\n in anello aperto')


%     Finished composite block 'anello aperto'.

set_param([sys,'/','anello aperto'],...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[360,235,495,285])


%     Subsystem  'anello chiuso'.

new_system([sys,'/','anello chiuso'])
set_param([sys,'/','anello chiuso'],'Location',[593,72,947,224])


%     Subsystem  'anello chiuso/y//y*'.

new_system([sys,'/','anello chiuso/y//y*'])
set_param([sys,'/','anello chiuso/y//y*'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','anello chiuso/y//y*/bode'])
set_param([sys,'/','anello chiuso/y//y*/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','anello chiuso/y//y*'],...
		'Mask Display','Bode y/y*',...
		'Mask Dialogue','eval(''bod2_rif'')')


%     Finished composite block 'anello chiuso/y//y*'.

set_param([sys,'/','anello chiuso/y//y*'],...
		'hide name',0,...
		'position',[20,35,95,75])


%     Subsystem  'anello chiuso/y//d1'.

new_system([sys,'/','anello chiuso/y//d1'])
set_param([sys,'/','anello chiuso/y//d1'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','anello chiuso/y//d1/bode'])
set_param([sys,'/','anello chiuso/y//d1/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','anello chiuso/y//d1'],...
		'Mask Display','Bode y/d',...
		'Mask Dialogue','eval(''bod2_d1'')')


%     Finished composite block 'anello chiuso/y//d1'.

set_param([sys,'/','anello chiuso/y//d1'],...
		'hide name',0,...
		'position',[120,35,205,76])


%     Subsystem  'anello chiuso/poli'.

new_system([sys,'/','anello chiuso/poli'])
set_param([sys,'/','anello chiuso/poli'],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/','anello chiuso/poli/assegna'])
set_param([sys,'/','anello chiuso/poli/assegna'],...
		'position',[95,45,100,50])
set_param([sys,'/','anello chiuso/poli'],...
		'Mask Display','poli',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_cl'')')


%     Finished composite block 'anello chiuso/poli'.

set_param([sys,'/','anello chiuso/poli'],...
		'hide name',0,...
		'position',[25,95,100,136])


%     Subsystem  'anello chiuso/u//y*'.

new_system([sys,'/','anello chiuso/u//y*'])
set_param([sys,'/','anello chiuso/u//y*'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','anello chiuso/u//y*/bode'])
set_param([sys,'/','anello chiuso/u//y*/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','anello chiuso/u//y*'],...
		'Mask Display','Bode u/y*',...
		'Mask Dialogue','eval(''bodu_rif'')')


%     Finished composite block 'anello chiuso/u//y*'.

set_param([sys,'/','anello chiuso/u//y*'],...
		'hide name',0,...
		'position',[240,35,315,75])
set_param([sys,'/','anello chiuso'],...
		'Mask Display','analisi\n in anello chiuso')


%     Finished composite block 'anello chiuso'.

set_param([sys,'/','anello chiuso'],...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[565,235,710,285])


%     Subsystem  'segnali'.

new_system([sys,'/','segnali'])
set_param([sys,'/','segnali'],'Location',[4,151,259,321])

add_block('built-in/Sine Wave',[sys,'/','segnali/sinusoide'])
set_param([sys,'/','segnali/sinusoide'],...
		'ForeGround',3,...
		'position',[30,38,65,72])


%     Subsystem  ['segnali/onda',13,'quadra'].

new_system([sys,'/',['segnali/onda',13,'quadra']])
set_param([sys,'/',['segnali/onda',13,'quadra']],'Location',[158,441,759,682])

add_block('built-in/Outport',[sys,'/',['segnali/onda',13,'quadra/out_1']])
set_param([sys,'/',['segnali/onda',13,'quadra/out_1']],...
		'hide name',0,...
		'position',[560,105,580,125])

add_block('built-in/Gain',[sys,'/',['segnali/onda',13,'quadra/Gain']])
set_param([sys,'/',['segnali/onda',13,'quadra/Gain']],...
		'hide name',0,...
		'Gain','ht',...
		'position',[510,102,535,128])

add_block('built-in/Product',[sys,'/',['segnali/onda',13,'quadra/Product']])
set_param([sys,'/',['segnali/onda',13,'quadra/Product']],...
		'hide name',0,...
		'position',[455,105,480,125])

add_block('built-in/Logical Operator',[sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator1']],...
		'Operator','NOT',...
		'Number of Input Ports','1',...
		'position',[355,38,385,62])

add_block('built-in/Logical Operator',[sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator']])
set_param([sys,'/',['segnali/onda',13,'quadra/Logical',13,'Operator']],...
		'Operator','XOR',...
		'position',[285,38,315,62])

add_block('built-in/Constant',[sys,'/',['segnali/onda',13,'quadra/Constant1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Constant1']],...
		'Value','stt',...
		'position',[295,149,320,171])

add_block('built-in/Clock',[sys,'/',['segnali/onda',13,'quadra/Clock1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Clock1']],...
		'hide name',0,...
		'position',[295,100,315,120])

add_block('built-in/Relational Operator',[sys,'/',['segnali/onda',13,'quadra/Relational',13,'operator']])
set_param([sys,'/',['segnali/onda',13,'quadra/Relational',13,'operator']],...
		'hide name',0,...
		'position',[370,102,400,133])

add_block('built-in/Sum',[sys,'/',['segnali/onda',13,'quadra/Sum1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Sum1']],...
		'hide name',0,...
		'inputs','+-',...
		'position',[130,120,150,140])

add_block('built-in/Sum',[sys,'/',['segnali/onda',13,'quadra/Sum']])
set_param([sys,'/',['segnali/onda',13,'quadra/Sum']],...
		'hide name',0,...
		'inputs','+-',...
		'position',[135,35,155,55])

add_block('built-in/Constant',[sys,'/',['segnali/onda',13,'quadra/Constant']])
set_param([sys,'/',['segnali/onda',13,'quadra/Constant']],...
		'position',[25,30,45,50])

add_block('built-in/Unit Delay',[sys,'/',['segnali/onda',13,'quadra/Unit Delay']])
set_param([sys,'/',['segnali/onda',13,'quadra/Unit Delay']],...
		'orientation',2,...
		'Sample time','[Ts,st1]',...
		'position',[145,75,195,95])

add_block('built-in/Unit Delay',[sys,'/',['segnali/onda',13,'quadra/Unit Delay1']])
set_param([sys,'/',['segnali/onda',13,'quadra/Unit Delay1']],...
		'orientation',2,...
		'Sample time','[Ts,st2]',...
		'x0','ini',...
		'position',[140,165,190,185])
add_line([sys,'/',['segnali/onda',13,'quadra']],[390,50;430,50;430,110;450,110])
add_line([sys,'/',['segnali/onda',13,'quadra']],[320,50;350,50])
add_line([sys,'/',['segnali/onda',13,'quadra']],[325,160;345,160;345,125;365,125])
add_line([sys,'/',['segnali/onda',13,'quadra']],[540,115;555,115])
add_line([sys,'/',['segnali/onda',13,'quadra']],[485,115;505,115])
add_line([sys,'/',['segnali/onda',13,'quadra']],[405,120;450,120])
add_line([sys,'/',['segnali/onda',13,'quadra']],[320,110;365,110])
add_line([sys,'/',['segnali/onda',13,'quadra']],[140,85;105,85;105,50;130,50])
add_line([sys,'/',['segnali/onda',13,'quadra']],[160,45;230,45;230,85;200,85])
add_line([sys,'/',['segnali/onda',13,'quadra']],[50,40;130,40])
add_line([sys,'/',['segnali/onda',13,'quadra']],[155,130;210,130;210,175;195,175])
add_line([sys,'/',['segnali/onda',13,'quadra']],[135,175;100,175;100,135;125,135])
add_line([sys,'/',['segnali/onda',13,'quadra']],[50,40;70,40;70,125;125,125])
add_line([sys,'/',['segnali/onda',13,'quadra']],[160,45;280,45])
add_line([sys,'/',['segnali/onda',13,'quadra']],[155,130;245,130;245,55;280,55])
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Display','plot(0,0,100,100,[90,75,75,60,60,35,35,20,20,10],[20,20,80,80,20,20,80,80,20,20])',...
		'Mask Type','Pulse Generator')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Dialogue','Pulse Generator.|Pulse period (secs):|Pulse width:|Pulse height:|Pulse start time:')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Translate','Ts=@1; du=@2; ht=@3; stt=@4; ini=ones(length(ht),1); st1=rem(stt,Ts); st2=rem(stt+du,Ts);if(Ts<=1.2*du),ini=zeros(length(ht),1);end;')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Help','Pulse generator which ensures pulse\ntransitions are hit. Provides a vector of pulses when the height is entered as a vector.\nUnmask to see how it works.')
set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'Mask Entries','2\/1\/1\/0\/')


%     Finished composite block ['segnali/onda',13,'quadra'].

set_param([sys,'/',['segnali/onda',13,'quadra']],...
		'ForeGround',3,...
		'position',[180,38,215,72])

add_block('built-in/Step Fcn',[sys,'/','segnali/scalino'])
set_param([sys,'/','segnali/scalino'],...
		'ForeGround',3,...
		'Time','0',...
		'position',[105,39,140,71])


%     Finished composite block 'segnali'.

set_param([sys,'/','segnali'],...
		'ForeGround',3,...
		'position',[25,14,55,66])


%     Subsystem  'connessioni'.

new_system([sys,'/','connessioni'])
set_param([sys,'/','connessioni'],'Location',[350,85,605,255])

add_block('built-in/Mux',[sys,'/','connessioni/Mux'])
set_param([sys,'/','connessioni/Mux'],...
		'hide name',0,...
		'inputs','2',...
		'position',[115,55,155,90])

add_block('built-in/Sum',[sys,'/','connessioni/differenza'])
set_param([sys,'/','connessioni/differenza'],...
		'hide name',0,...
		'inputs','+-',...
		'position',[125,115,150,155])


%     Finished composite block 'connessioni'.

set_param([sys,'/','connessioni'],...
		'position',[25,135,55,187])

add_block('built-in/Sum',[sys,'/','somma '])
set_param([sys,'/','somma '],...
		'hide name',0,...
		'Font Size',11,...
		'position',[570,78,590,107])


%     Subsystem  'help'.

new_system([sys,'/','help'])
set_param([sys,'/','help'],'Location',[217,247,750,430])

add_block('built-in/Note',[sys,'/',['help/i blocchi con l''ombreggiatura consentono ',13,'']])
set_param([sys,'/',['help/i blocchi con l''ombreggiatura consentono ',13,'']],...
		'Font Name','Arial',...
		'position',[150,30,155,35])

add_block('built-in/Note',[sys,'/',['help/-  l''inserimento della funzione di trasferimento ']])
set_param([sys,'/',['help/-  l''inserimento della funzione di trasferimento ']],...
		'position',[165,70,170,75])

add_block('built-in/Note',[sys,'/',['help/ - l''ottenimento dei diagrammi di Bode e di Nyquist']])
set_param([sys,'/',['help/ - l''ottenimento dei diagrammi di Bode e di Nyquist']],...
		'position',[180,100,185,105])

add_block('built-in/Note',[sys,'/','help/- la determinazione delle singolarit (poli e//o zeri) e//o del guadagno'])
set_param([sys,'/','help/- la determinazione delle singolarit (poli e//o zeri) e//o del guadagno'],...
		'position',[230,135,235,140])
set_param([sys,'/','help'],...
		'Mask Display','?')


%     Finished composite block 'help'.

set_param([sys,'/','help'],...
		'hide name',0,...
		'Font Size',20,...
		'Drop Shadow',4,...
		'position',[757,180,805,227])

add_block('built-in/Note',[sys,'/','u'])
set_param([sys,'/','u'],...
		'ForeGround',6,...
		'Font Weight','bold',...
		'position',[395,70,400,75])


%     Subsystem  'sistema 1'.

new_system([sys,'/','sistema 1'])
set_param([sys,'/','sistema 1'],'Location',[250,71,465,196])

add_block('built-in/Outport',[sys,'/','sistema 1/out_1'])
set_param([sys,'/','sistema 1/out_1'],...
		'position',[200,65,220,85])

add_block('built-in/Inport',[sys,'/','sistema 1/in_1'])
set_param([sys,'/','sistema 1/in_1'],...
		'position',[15,65,35,85])

add_block('built-in/Transfer Fcn',[sys,'/','sistema 1/Transfer Fcn'])
set_param([sys,'/','sistema 1/Transfer Fcn'],...
		'ForeGround',4,...
		'hide name',0,...
		'Numerator','num',...
		'Denominator','den',...
		'position',[115,57,185,93])


%     Subsystem  'sistema 1/delay'.

new_system([sys,'/','sistema 1/delay'])
set_param([sys,'/','sistema 1/delay'],'Location',[125,196,380,426])

add_block('built-in/Transport Delay',[sys,'/',['sistema 1/delay/Transport',13,'Delay']])
set_param([sys,'/',['sistema 1/delay/Transport',13,'Delay']],...
		'ForeGround',4,...
		'hide name',0,...
		'Delay Time','T',...
		'position',[85,165,125,195])

add_block('built-in/Note',[sys,'/','sistema 1/delay/1 se T=0'])
set_param([sys,'/','sistema 1/delay/1 se T=0'],...
		'position',[135,95,140,100])

add_block('built-in/Switch',[sys,'/','sistema 1/delay/Switch'])
set_param([sys,'/','sistema 1/delay/Switch'],...
		'Threshold','.5',...
		'position',[180,104,210,136])


%     Subsystem  'sistema 1/delay/control'.

new_system([sys,'/','sistema 1/delay/control'])
set_param([sys,'/','sistema 1/delay/control'],'Location',[65,181,260,331])

add_block('built-in/Constant',[sys,'/','sistema 1/delay/control/T'])
set_param([sys,'/','sistema 1/delay/control/T'],...
		'Value','T',...
		'position',[20,45,40,65])

add_block('built-in/Constant',[sys,'/','sistema 1/delay/control/zero'])
set_param([sys,'/','sistema 1/delay/control/zero'],...
		'Value','0',...
		'position',[20,95,40,115])

add_block('built-in/Relational Operator',[sys,'/','sistema 1/delay/control/uguale'])
set_param([sys,'/','sistema 1/delay/control/uguale'],...
		'Operator','==',...
		'position',[105,53,135,77])

add_block('built-in/Outport',[sys,'/','sistema 1/delay/control/out_1'])
set_param([sys,'/','sistema 1/delay/control/out_1'],...
		'position',[200,55,220,75])
add_line([sys,'/','sistema 1/delay/control'],[45,105;65,105;65,70;100,70])
add_line([sys,'/','sistema 1/delay/control'],[45,55;100,60])
add_line([sys,'/','sistema 1/delay/control'],[140,65;195,65])


%     Finished composite block 'sistema 1/delay/control'.

set_param([sys,'/','sistema 1/delay/control'],...
		'position',[70,105,95,135])

add_block('built-in/Outport',[sys,'/','sistema 1/delay/out_1'])
set_param([sys,'/','sistema 1/delay/out_1'],...
		'position',[240,110,260,130])

add_block('built-in/Inport',[sys,'/','sistema 1/delay/in_1'])
set_param([sys,'/','sistema 1/delay/in_1'],...
		'position',[15,110,35,130])
add_line([sys,'/','sistema 1/delay'],[130,180;160,180;160,130;175,130])
add_line([sys,'/','sistema 1/delay'],[40,120;50,120;50,60;165,60;175,110])
add_line([sys,'/','sistema 1/delay'],[50,120;50,180;80,180])
add_line([sys,'/','sistema 1/delay'],[215,120;235,120])
add_line([sys,'/','sistema 1/delay'],[100,120;175,120])


%     Finished composite block 'sistema 1/delay'.

set_param([sys,'/','sistema 1/delay'],...
		'position',[70,56,90,94])
add_line([sys,'/','sistema 1'],[190,75;195,75])
add_line([sys,'/','sistema 1'],[40,75;65,75])
add_line([sys,'/','sistema 1'],[95,75;110,75])
set_param([sys,'/','sistema 1'],...
		'Mask Display','sistema',...
		'Mask Dialogue','eval(''blocca'')')


%     Finished composite block 'sistema 1'.

set_param([sys,'/','sistema 1'],...
		'ForeGround',4,...
		'hide name',0,...
		'Font Size',11,...
		'position',[430,75,505,125])


%     Subsystem  'saturazione'.

new_system([sys,'/','saturazione'])
set_param([sys,'/','saturazione'],'Location',[275,92,410,237])

add_block('built-in/Saturation',[sys,'/','saturazione/saturazione'])
set_param([sys,'/','saturazione/saturazione'],...
		'ForeGround',6,...
		'hide name',0,...
		'Lower Limit','lowerlimit',...
		'Upper Limit','upperlimit',...
		'position',[60,66,95,104])

add_block('built-in/Outport',[sys,'/','saturazione/out_1'])
set_param([sys,'/','saturazione/out_1'],...
		'position',[120,75,140,95])

add_block('built-in/Inport',[sys,'/','saturazione/in_1'])
set_param([sys,'/','saturazione/in_1'],...
		'position',[15,75,35,95])
add_line([sys,'/','saturazione'],[100,85;115,85])
add_line([sys,'/','saturazione'],[40,85;55,85])
set_param([sys,'/','saturazione'],...
		'Mask Display','A',...
		'Mask Type','Attuatore con saturazione',...
		'Mask Dialogue','Attuatore con saturazione.|Limite inferiore:|Limite superiore:')
set_param([sys,'/','saturazione'],...
		'Mask Translate','lowerlimit=@1;upperlimit=@2;end;',...
		'Mask Entries','-inf\/inf\/')


%     Finished composite block 'saturazione'.

set_param([sys,'/','saturazione'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[335,82,370,118])

add_block('built-in/Transfer Fcn',[sys,'/','controllore '])
set_param([sys,'/','controllore '],...
		'ForeGround',6,...
		'hide name',0,...
		'Font Size',11,...
		'Numerator','num_c',...
		'Denominator','den_c',...
		'Mask Display','controllore',...
		'Mask Dialogue','eval(''blocca'')')
set_param([sys,'/','controllore '],...
		'position',[180,75,290,125])
add_line(sys,[510,100;565,100])
add_line(sys,[595,95;660,95;660,170;95,170;105,105])
add_line(sys,[660,100;660,95;700,95])
add_line(sys,[130,100;175,100])
add_line(sys,[295,100;330,100])
add_line(sys,[375,100;425,100])

drawnow

% Return any arguments.
if (nargin | nargout)
	% Must use feval here to access system in memory
	if (nargin > 3)
		if (flag == 0)
			eval(['[ret,x0,str,ts,xts]=',sys,'(t,x,u,flag);'])
		else
			eval(['ret =', sys,'(t,x,u,flag);'])
		end
	else
		[ret,x0,str,ts,xts] = feval(sys);
	end
else
	drawnow % Flash up the model and execute load callback
end
