function [ret,x0,str,ts,xts]=pid(t,x,u,flag);
%PID	is the M-file description of the SIMULINK system named PID.
%	The block-diagram can be displayed by typing: PID.
%
%	SYS=PID(T,X,U,FLAG) returns depending on FLAG certain
%	system values given time point, T, current state vector, X,
%	and input vector, U.
%	FLAG is used to indicate the type of output to be returned in SYS.
%
%	Setting FLAG=1 causes PID to return state derivatives, FLAG=2
%	discrete states, FLAG=3 system outputs and FLAG=4 next sample
%	time. For more information and other options see SFUNC.
%
%	Calling PID with a FLAG of zero:
%	[SIZES]=PID([],[],[],0),  returns a vector, SIZES, which
%	contains the sizes of the state vector and other parameters.
%		SIZES(1) number of states
%		SIZES(2) number of discrete states
%		SIZES(3) number of outputs
%		SIZES(4) number of inputs
%		SIZES(5) number of roots (currently unsupported)
%		SIZES(6) direct feedthrough flag
%		SIZES(7) number of sample times
%
%	For the definition of other parameters in SIZES, see SFUNC.
%	See also, TRIM, LINMOD, LINSIM, EULER, RK23, RK45, ADAMS, GEAR.

% Note: This M-file is only used for saving graphical information;
%       after the model is loaded into memory an internal model
%       representation is used.

% the system will take on the name of this mfile:
sys = mfilename;
new_system(sys)
simver(1.3)
if (0 == (nargin + nargout))
     set_param(sys,'Location',[4,42,783,376])
     open_system(sys)
end;
set_param(sys,'algorithm',     'RK-23')
set_param(sys,'Start time',    '0.0')
set_param(sys,'Stop time',     '50')
set_param(sys,'Min step size', '0.0001')
set_param(sys,'Max step size', '10')
set_param(sys,'Relative error','1e-3')
set_param(sys,'Return vars',   '')


%     Subsystem  'connessioni'.

new_system([sys,'/','connessioni'])
set_param([sys,'/','connessioni'],'Location',[350,85,605,255])

add_block('built-in/Mux',[sys,'/','connessioni/Mux'])
set_param([sys,'/','connessioni/Mux'],...
		'hide name',0,...
		'inputs','2',...
		'position',[120,50,160,85])

add_block('built-in/Sum',[sys,'/','connessioni/somma'])
set_param([sys,'/','connessioni/somma'],...
		'hide name',0,...
		'inputs','+-',...
		'position',[135,105,160,145])


%     Finished composite block 'connessioni'.

set_param([sys,'/','connessioni'],...
		'position',[30,115,60,167])


%     Subsystem  'anello aperto'.

new_system([sys,'/','anello aperto'])
set_param([sys,'/','anello aperto'],'Location',[55,193,486,278])


%     Subsystem  'anello aperto/Diagrammi'.

new_system([sys,'/','anello aperto/Diagrammi'])
set_param([sys,'/','anello aperto/Diagrammi'],'Location',[10,245,262,384])


%     Subsystem  'anello aperto/Diagrammi/Nyquist'.

new_system([sys,'/','anello aperto/Diagrammi/Nyquist'])
set_param([sys,'/','anello aperto/Diagrammi/Nyquist'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','anello aperto/Diagrammi/Nyquist/bode'])
set_param([sys,'/','anello aperto/Diagrammi/Nyquist/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','anello aperto/Diagrammi/Nyquist'],...
		'Mask Display','Nyquist',...
		'Mask Dialogue','eval(''nyq_tot'')')


%     Finished composite block 'anello aperto/Diagrammi/Nyquist'.

set_param([sys,'/','anello aperto/Diagrammi/Nyquist'],...
		'hide name',0,...
		'position',[140,50,195,90])


%     Subsystem  'anello aperto/Diagrammi/Bode'.

new_system([sys,'/','anello aperto/Diagrammi/Bode'])
set_param([sys,'/','anello aperto/Diagrammi/Bode'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','anello aperto/Diagrammi/Bode/bode'])
set_param([sys,'/','anello aperto/Diagrammi/Bode/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','anello aperto/Diagrammi/Bode'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_tot'')')


%     Finished composite block 'anello aperto/Diagrammi/Bode'.

set_param([sys,'/','anello aperto/Diagrammi/Bode'],...
		'hide name',0,...
		'position',[50,50,105,91])
set_param([sys,'/','anello aperto/Diagrammi'],...
		'Mask Display','diagrammi\n  \n (Bode e Nyquist)')


%     Finished composite block 'anello aperto/Diagrammi'.

set_param([sys,'/','anello aperto/Diagrammi'],...
		'hide name',0,...
		'position',[55,25,170,72])


%     Subsystem  ['anello aperto/singolarita'''].

new_system([sys,'/',['anello aperto/singolarita''']])
set_param([sys,'/',['anello aperto/singolarita''']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['anello aperto/singolarita''/assegna']])
set_param([sys,'/',['anello aperto/singolarita''/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['anello aperto/singolarita''']],...
		'Mask Display','singolarit,\n guadagno e ritardo',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_tot'')')


%     Finished composite block ['anello aperto/singolarita'''].

set_param([sys,'/',['anello aperto/singolarita''']],...
		'hide name',0,...
		'position',[225,20,360,71])
set_param([sys,'/','anello aperto'],...
		'Mask Display','analisi\n in anello aperto')


%     Finished composite block 'anello aperto'.

set_param([sys,'/','anello aperto'],...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[570,235,705,285])


%     Subsystem  'controllore'.

new_system([sys,'/','controllore'])
set_param([sys,'/','controllore'],'Location',[87,95,562,268])


%     Subsystem  'controllore/f.d.t.'.

new_system([sys,'/','controllore/f.d.t.'])
set_param([sys,'/','controllore/f.d.t.'],'Location',[10,269,185,379])

add_block('built-in/Note',[sys,'/','controllore/f.d.t./assegna'])
set_param([sys,'/','controllore/f.d.t./assegna'],...
		'position',[95,45,100,50])
set_param([sys,'/','controllore/f.d.t.'],...
		'Mask Display','inserimento f.d.t.',...
		'Mask Type','assegnamento controllore',...
		'Mask Dialogue','eval(''ass2_cn'')')


%     Finished composite block 'controllore/f.d.t.'.

set_param([sys,'/','controllore/f.d.t.'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[20,30,155,81])


%     Subsystem  'controllore/diagrammi'.

new_system([sys,'/','controllore/diagrammi'])
set_param([sys,'/','controllore/diagrammi'],'Location',[206,153,448,246])


%     Subsystem  'controllore/diagrammi/Bode'.

new_system([sys,'/','controllore/diagrammi/Bode'])
set_param([sys,'/','controllore/diagrammi/Bode'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','controllore/diagrammi/Bode/bode'])
set_param([sys,'/','controllore/diagrammi/Bode/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','controllore/diagrammi/Bode'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_c'')')


%     Finished composite block 'controllore/diagrammi/Bode'.

set_param([sys,'/','controllore/diagrammi/Bode'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[100,35,155,75])
set_param([sys,'/','controllore/diagrammi'],...
		'Mask Display','diagramma di Bode')


%     Finished composite block 'controllore/diagrammi'.

set_param([sys,'/','controllore/diagrammi'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[165,30,290,81])


%     Subsystem  ['controllore/singolarita'' e guadagno'].

new_system([sys,'/',['controllore/singolarita'' e guadagno']])
set_param([sys,'/',['controllore/singolarita'' e guadagno']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['controllore/singolarita'' e guadagno/assegna']])
set_param([sys,'/',['controllore/singolarita'' e guadagno/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['controllore/singolarita'' e guadagno']],...
		'Mask Display','singolarit e guadagno',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_c'')')


%     Finished composite block ['controllore/singolarita'' e guadagno'].

set_param([sys,'/',['controllore/singolarita'' e guadagno']],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[305,30,440,81])
set_param([sys,'/','controllore'],...
		'Mask Display','PID')


%     Finished composite block 'controllore'.

set_param([sys,'/','controllore'],...
		'ForeGround',6,...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[380,235,485,285])


%     Subsystem  'sistema'.

new_system([sys,'/','sistema'])
set_param([sys,'/','sistema'],'Location',[43,166,550,258])


%     Subsystem  'sistema/f.d.t.'.

new_system([sys,'/','sistema/f.d.t.'])
set_param([sys,'/','sistema/f.d.t.'],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/','sistema/f.d.t./assegna'])
set_param([sys,'/','sistema/f.d.t./assegna'],...
		'position',[95,45,100,50])
set_param([sys,'/','sistema/f.d.t.'],...
		'Mask Display','inserimento\n f.d.t.',...
		'Mask Type','assegnamento sistema',...
		'Mask Dialogue','eval(''ass_sis'')')


%     Finished composite block 'sistema/f.d.t.'.

set_param([sys,'/','sistema/f.d.t.'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[55,15,155,56])


%     Subsystem  ['sistema/singolarita'' e guadagno'].

new_system([sys,'/',['sistema/singolarita'' e guadagno']])
set_param([sys,'/',['sistema/singolarita'' e guadagno']],'Location',[10,5308685,185,5308795])

add_block('built-in/Note',[sys,'/',['sistema/singolarita'' e guadagno/assegna']])
set_param([sys,'/',['sistema/singolarita'' e guadagno/assegna']],...
		'position',[95,45,100,50])
set_param([sys,'/',['sistema/singolarita'' e guadagno']],...
		'Mask Display','singolarit,\n guadagno e ritardo',...
		'Mask Type','singolarita'' della f.d.t.',...
		'Mask Dialogue','eval(''sing_s'')')


%     Finished composite block ['sistema/singolarita'' e guadagno'].

set_param([sys,'/',['sistema/singolarita'' e guadagno']],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[350,15,485,66])


%     Subsystem  'sistema/diagrammi'.

new_system([sys,'/','sistema/diagrammi'])
set_param([sys,'/','sistema/diagrammi'],'Location',[34,236,276,329])


%     Subsystem  'sistema/diagrammi/Bode'.

new_system([sys,'/','sistema/diagrammi/Bode'])
set_param([sys,'/','sistema/diagrammi/Bode'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','sistema/diagrammi/Bode/bode'])
set_param([sys,'/','sistema/diagrammi/Bode/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','sistema/diagrammi/Bode'],...
		'Mask Display','Bode',...
		'Mask Dialogue','eval(''bode_sis'')')


%     Finished composite block 'sistema/diagrammi/Bode'.

set_param([sys,'/','sistema/diagrammi/Bode'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[30,35,85,75])


%     Subsystem  'sistema/diagrammi/Nyquist'.

new_system([sys,'/','sistema/diagrammi/Nyquist'])
set_param([sys,'/','sistema/diagrammi/Nyquist'],'Location',[240,349,375,439])

add_block('built-in/Note',[sys,'/','sistema/diagrammi/Nyquist/bode'])
set_param([sys,'/','sistema/diagrammi/Nyquist/bode'],...
		'position',[55,40,60,45])
set_param([sys,'/','sistema/diagrammi/Nyquist'],...
		'Mask Display','Nyquist',...
		'Mask Dialogue','eval(''nyq_sis'')')


%     Finished composite block 'sistema/diagrammi/Nyquist'.

set_param([sys,'/','sistema/diagrammi/Nyquist'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[120,35,175,75])
set_param([sys,'/','sistema/diagrammi'],...
		'Mask Display','diagrammi\n  \n (Bode e Nyquist)')


%     Finished composite block 'sistema/diagrammi'.

set_param([sys,'/','sistema/diagrammi'],...
		'ForeGround',4,...
		'hide name',0,...
		'position',[205,10,315,62])
set_param([sys,'/','sistema'],...
		'Mask Display','sistema')


%     Finished composite block 'sistema'.

set_param([sys,'/','sistema'],...
		'ForeGround',4,...
		'hide name',0,...
		'Drop Shadow',4,...
		'position',[195,235,285,280])


%     Subsystem  'help1'.

new_system([sys,'/','help1'])
set_param([sys,'/','help1'],'Location',[217,247,750,430])

add_block('built-in/Note',[sys,'/',['help1/i blocchi con l''ombreggiatura consentono ',13,'']])
set_param([sys,'/',['help1/i blocchi con l''ombreggiatura consentono ',13,'']],...
		'Font Name','Arial',...
		'position',[150,30,155,35])

add_block('built-in/Note',[sys,'/',['help1/-  l''inserimento della funzione di trasferimento ']])
set_param([sys,'/',['help1/-  l''inserimento della funzione di trasferimento ']],...
		'position',[165,70,170,75])

add_block('built-in/Note',[sys,'/',['help1/ - l''ottenimento dei diagrammi di Bode e di Nyquist']])
set_param([sys,'/',['help1/ - l''ottenimento dei diagrammi di Bode e di Nyquist']],...
		'position',[180,100,185,105])

add_block('built-in/Note',[sys,'/','help1/- la determinazione delle singolarit, del guadagno e del ritardo'])
set_param([sys,'/','help1/- la determinazione delle singolarit, del guadagno e del ritardo'],...
		'position',[215,135,220,140])
set_param([sys,'/','help1'],...
		'Mask Display','?')


%     Finished composite block 'help1'.

set_param([sys,'/','help1'],...
		'hide name',0,...
		'Font Size',20,...
		'Drop Shadow',4,...
		'position',[50,230,98,277])


%     Subsystem  'PID Controller'.

new_system([sys,'/','PID Controller'])
set_param([sys,'/','PID Controller'],'Location',[4,42,366,286])

add_block('built-in/Sum',[sys,'/','PID Controller/Sum'])
set_param([sys,'/','PID Controller/Sum'],...
		'inputs','+++',...
		'position',[245,57,265,93])

add_block('built-in/Gain',[sys,'/','PID Controller/D'])
set_param([sys,'/','PID Controller/D'],...
		'Gain','D',...
		'position',[95,129,115,151])

add_block('built-in/Gain',[sys,'/','PID Controller/Proportional'])
set_param([sys,'/','PID Controller/Proportional'],...
		'Gain','K',...
		'position',[120,13,140,37])

add_block('built-in/Transfer Fcn',[sys,'/','PID Controller/Integral'])
set_param([sys,'/','PID Controller/Integral'],...
		'Numerator','[I]',...
		'Denominator','[1 0]',...
		'position',[110,57,145,93])

add_block('built-in/Derivative',[sys,'/','PID Controller/Derivative'])
set_param([sys,'/','PID Controller/Derivative'],...
		'position',[150,128,190,152])

add_block('built-in/Outport',[sys,'/','PID Controller/Out_1'])
set_param([sys,'/','PID Controller/Out_1'],...
		'position',[290,65,310,85])

add_block('built-in/Inport',[sys,'/','PID Controller/In_1'])
set_param([sys,'/','PID Controller/In_1'],...
		'position',[25,65,45,85])
add_line([sys,'/','PID Controller'],[120,140;145,140])
add_line([sys,'/','PID Controller'],[270,75;285,75])
add_line([sys,'/','PID Controller'],[50,75;105,75])
add_line([sys,'/','PID Controller'],[65,75;65,140;90,140])
add_line([sys,'/','PID Controller'],[80,75;80,25;115,25])
add_line([sys,'/','PID Controller'],[195,140;215,140;215,85;240,85])
add_line([sys,'/','PID Controller'],[150,75;240,75])
add_line([sys,'/','PID Controller'],[145,25;210,25;210,65;240,65])
set_param([sys,'/','PID Controller'],...
		'Mask Display','PID',...
		'Mask Dialogue','eval(''blocca'')')
set_param([sys,'/','PID Controller'],...
		'Mask Help','This block implements a PID controller where parameters are entered for the Proportional, Integral and Derivative terms. Unmask this block to see how it works. The derivative term is implemented using a true derivative block.')


%     Finished composite block 'PID Controller'.

set_param([sys,'/','PID Controller'],...
		'ForeGround',6,...
		'hide name',0,...
		'position',[210,109,285,141])

add_block('built-in/Note',[sys,'/','y*'])
set_param([sys,'/','y*'],...
		'ForeGround',3,...
		'Font Weight','bold',...
		'position',[130,80,135,85])

add_block('built-in/Sum',[sys,'/','differenza'])
set_param([sys,'/','differenza'],...
		'hide name',0,...
		'Font Size',11,...
		'inputs','+-',...
		'position',[150,109,165,136])

add_block('built-in/Sum',[sys,'/','somma'])
set_param([sys,'/','somma'],...
		'ForeGround',6,...
		'hide name',0,...
		'Font Size',11,...
		'position',[340,104,360,131])

add_block('built-in/Note',[sys,'/','d3'])
set_param([sys,'/','d3'],...
		'ForeGround',3,...
		'Font Weight','bold',...
		'position',[315,80,320,85])

add_block('built-in/Note',[sys,'/','u'])
set_param([sys,'/','u'],...
		'ForeGround',6,...
		'Font Weight','bold',...
		'position',[380,90,385,95])


%     Subsystem  'sistema '.

new_system([sys,'/','sistema '])
set_param([sys,'/','sistema '],'Location',[250,71,465,196])

add_block('built-in/Outport',[sys,'/','sistema /out_1'])
set_param([sys,'/','sistema /out_1'],...
		'position',[200,65,220,85])

add_block('built-in/Inport',[sys,'/','sistema /in_1'])
set_param([sys,'/','sistema /in_1'],...
		'position',[15,65,35,85])

add_block('built-in/Transfer Fcn',[sys,'/','sistema /Transfer Fcn'])
set_param([sys,'/','sistema /Transfer Fcn'],...
		'ForeGround',4,...
		'hide name',0,...
		'Numerator','num',...
		'Denominator','den',...
		'position',[115,57,185,93])


%     Subsystem  'sistema /delay'.

new_system([sys,'/','sistema /delay'])
set_param([sys,'/','sistema /delay'],'Location',[125,196,380,426])

add_block('built-in/Transport Delay',[sys,'/',['sistema /delay/Transport',13,'Delay']])
set_param([sys,'/',['sistema /delay/Transport',13,'Delay']],...
		'ForeGround',4,...
		'hide name',0,...
		'Delay Time','T',...
		'position',[85,165,125,195])

add_block('built-in/Note',[sys,'/','sistema /delay/1 se T=0'])
set_param([sys,'/','sistema /delay/1 se T=0'],...
		'position',[135,95,140,100])

add_block('built-in/Switch',[sys,'/','sistema /delay/Switch'])
set_param([sys,'/','sistema /delay/Switch'],...
		'Threshold','.5',...
		'position',[180,104,210,136])


%     Subsystem  'sistema /delay/control'.

new_system([sys,'/','sistema /delay/control'])
set_param([sys,'/','sistema /delay/control'],'Location',[65,181,260,331])

add_block('built-in/Constant',[sys,'/','sistema /delay/control/T'])
set_param([sys,'/','sistema /delay/control/T'],...
		'Value','T',...
		'position',[20,45,40,65])

add_block('built-in/Constant',[sys,'/','sistema /delay/control/zero'])
set_param([sys,'/','sistema /delay/control/zero'],...
		'Value','0',...
		'position',[20,95,40,115])

add_block('built-in/Relational Operator',[sys,'/','sistema /delay/control/uguale'])
set_param([sys,'/','sistema /delay/control/uguale'],...
		'Operator','==',...
		'position',[105,53,135,77])

add_block('built-in/Outport',[sys,'/','sistema /delay/control/out_1'])
set_param([sys,'/','sistema /delay/control/out_1'],...
		'position',[200,55,220,75])
add_line([sys,'/','sistema /delay/control'],[45,105;65,105;65,70;100,70])
add_line([sys,'/','sistema /delay/control'],[45,55;100,60])
add_line([sys,'/','sistema /delay/control'],[140,65;195,65])


%     Finished composite block 'sistema /delay/control'.

set_param([sys,'/','sistema /delay/control'],...
		'position',[70,105,95,135])

add_block('built-in/Outport',[sys,'/','sistema /delay/out_1'])
set_param([sys,'/','sistema /delay/out_1'],...
		'position',[240,110,260,130])

add_block('built-in/Inport',[sys,'/','sistema /delay/in_1'])
set_param([sys,'/','sistema /delay/in_1'],...
		'position',[15,110,35,130])
add_line([sys,'/','sistema /delay'],[130,180;160,180;160,130;175,130])
add_line([sys,'/','sistema /delay'],[40,120;50,120;50,60;165,60;175,110])
add_line([sys,'/','sistema /delay'],[50,120;50,180;80,180])
add_line([sys,'/','sistema /delay'],[215,120;235,120])
add_line([sys,'/','sistema /delay'],[100,120;175,120])


%     Finished composite block 'sistema /delay'.

set_param([sys,'/','sistema /delay'],...
		'position',[70,56,90,94])
add_line([sys,'/','sistema '],[190,75;195,75])
add_line([sys,'/','sistema '],[95,75;110,75])
add_line([sys,'/','sistema '],[40,75;65,75])
set_param([sys,'/','sistema '],...
		'Mask Display','sistema',...
		'Mask Dialogue','eval(''blocca'')')


%     Finished composite block 'sistema '.

set_param([sys,'/','sistema '],...
		'ForeGround',4,...
		'hide name',0,...
		'Font Size',11,...
		'position',[410,95,485,145])

add_block('built-in/Sum',[sys,'/','somma '])
set_param([sys,'/','somma '],...
		'hide name',0,...
		'Font Size',11,...
		'position',[545,98,565,127])

add_block('built-in/Note',[sys,'/','d1'])
set_param([sys,'/','d1'],...
		'ForeGround',3,...
		'Font Weight','bold',...
		'position',[520,70,525,75])


%     Subsystem  'grafico'.

new_system([sys,'/','grafico'])
set_param([sys,'/','grafico'],'Location',[4,61,278,254])

add_block('built-in/S-Function',[sys,'/',['grafico/S-function',13,'M-file which plots',13,'lines',13,'']])
set_param([sys,'/',['grafico/S-function',13,'M-file which plots',13,'lines',13,'']],...
		'function name','sfunyst',...
		'parameters','ax, color, npts, dt',...
		'position',[130,55,180,75])

add_block('built-in/Inport',[sys,'/','grafico/x'])
set_param([sys,'/','grafico/x'],...
		'position',[65,55,85,75])
add_line([sys,'/','grafico'],[90,65;125,65])
set_param([sys,'/','grafico'],...
		'Mask Display','plot(0,0,100,100,[83,76,63,52,42,38,28,16,11,84,11,11,11,90,90,11],[75,58,47,54,72,80,84,74,65,65,65,90,40,40,90,90])',...
		'Mask Type','Storage scope.')
set_param([sys,'/','grafico'],...
		'Mask Dialogue','Storage scope using MATLAB graph window.\nEnter plotting ranges and line type.|Initial Time Range:|Initial y-min:|Initial y-max:|Storage pts.:|Line type (rgbw-.:xo):')
set_param([sys,'/','grafico'],...
		'Mask Translate','npts = @4; color = @5; ax = [0, @1, @2, @3]; dt=-1;')
set_param([sys,'/','grafico'],...
		'Mask Help','This block uses a MATLAB figure window to plot the input signal.  The graph limits are automatically scaled to the min and max values of the signal stored in the scope''s signal buffer.  Line type must be in quotes.  See the M-file sfunyst.m.')
set_param([sys,'/','grafico'],...
		'Mask Entries','10\/-10\/10\/2000\/''y-/g--/c-./w:/m*/ro/b+''\/')


%     Finished composite block 'grafico'.

set_param([sys,'/','grafico'],...
		'ForeGround',5,...
		'position',[685,92,720,138])

add_block('built-in/Sum',[sys,'/',' somma '])
set_param([sys,'/',' somma '],...
		'orientation',2,...
		'hide name',0,...
		'Font Size',11,...
		'position',[525,175,545,210])

add_block('built-in/Note',[sys,'/','d2'])
set_param([sys,'/','d2'],...
		'ForeGround',3,...
		'Font Weight','bold',...
		'position',[570,205,575,210])


%     Subsystem  'segnali'.

new_system([sys,'/','segnali'])
set_param([sys,'/','segnali'],'Location',[37,85,292,255])

add_block('built-in/Sine Wave',[sys,'/','segnali/sinusoide'])
set_param([sys,'/','segnali/sinusoide'],...
		'ForeGround',3,...
		'position',[30,78,65,112])

add_block('built-in/Step Fcn',[sys,'/','segnali/scalino'])
set_param([sys,'/','segnali/scalino'],...
		'ForeGround',3,...
		'Time','0',...
		'position',[105,74,140,106])


%     Subsystem  'segnali/onda quadra'.

new_system([sys,'/','segnali/onda quadra'])
set_param([sys,'/','segnali/onda quadra'],'Location',[158,441,759,682])

add_block('built-in/Outport',[sys,'/','segnali/onda quadra/out_1'])
set_param([sys,'/','segnali/onda quadra/out_1'],...
		'hide name',0,...
		'position',[560,105,580,125])

add_block('built-in/Gain',[sys,'/','segnali/onda quadra/Gain'])
set_param([sys,'/','segnali/onda quadra/Gain'],...
		'hide name',0,...
		'Gain','ht',...
		'position',[510,102,535,128])

add_block('built-in/Product',[sys,'/','segnali/onda quadra/Product'])
set_param([sys,'/','segnali/onda quadra/Product'],...
		'hide name',0,...
		'position',[455,105,480,125])

add_block('built-in/Logical Operator',[sys,'/',['segnali/onda quadra/Logical',13,'Operator1']])
set_param([sys,'/',['segnali/onda quadra/Logical',13,'Operator1']],...
		'Operator','NOT',...
		'Number of Input Ports','1',...
		'position',[355,38,385,62])

add_block('built-in/Logical Operator',[sys,'/',['segnali/onda quadra/Logical',13,'Operator']])
set_param([sys,'/',['segnali/onda quadra/Logical',13,'Operator']],...
		'Operator','XOR',...
		'position',[285,38,315,62])

add_block('built-in/Constant',[sys,'/','segnali/onda quadra/Constant1'])
set_param([sys,'/','segnali/onda quadra/Constant1'],...
		'Value','stt',...
		'position',[295,149,320,171])

add_block('built-in/Clock',[sys,'/','segnali/onda quadra/Clock1'])
set_param([sys,'/','segnali/onda quadra/Clock1'],...
		'hide name',0,...
		'position',[295,100,315,120])

add_block('built-in/Relational Operator',[sys,'/',['segnali/onda quadra/Relational',13,'operator']])
set_param([sys,'/',['segnali/onda quadra/Relational',13,'operator']],...
		'hide name',0,...
		'position',[370,102,400,133])

add_block('built-in/Sum',[sys,'/','segnali/onda quadra/Sum1'])
set_param([sys,'/','segnali/onda quadra/Sum1'],...
		'hide name',0,...
		'inputs','+-',...
		'position',[130,120,150,140])

add_block('built-in/Sum',[sys,'/','segnali/onda quadra/Sum'])
set_param([sys,'/','segnali/onda quadra/Sum'],...
		'hide name',0,...
		'inputs','+-',...
		'position',[135,35,155,55])

add_block('built-in/Constant',[sys,'/','segnali/onda quadra/Constant'])
set_param([sys,'/','segnali/onda quadra/Constant'],...
		'position',[25,30,45,50])

add_block('built-in/Unit Delay',[sys,'/','segnali/onda quadra/Unit Delay'])
set_param([sys,'/','segnali/onda quadra/Unit Delay'],...
		'orientation',2,...
		'Sample time','[Ts,st1]',...
		'position',[145,75,195,95])

add_block('built-in/Unit Delay',[sys,'/','segnali/onda quadra/Unit Delay1'])
set_param([sys,'/','segnali/onda quadra/Unit Delay1'],...
		'orientation',2,...
		'Sample time','[Ts,st2]',...
		'x0','ini',...
		'position',[140,165,190,185])
add_line([sys,'/','segnali/onda quadra'],[390,50;430,50;430,110;450,110])
add_line([sys,'/','segnali/onda quadra'],[320,50;350,50])
add_line([sys,'/','segnali/onda quadra'],[325,160;345,160;345,125;365,125])
add_line([sys,'/','segnali/onda quadra'],[540,115;555,115])
add_line([sys,'/','segnali/onda quadra'],[485,115;505,115])
add_line([sys,'/','segnali/onda quadra'],[405,120;450,120])
add_line([sys,'/','segnali/onda quadra'],[320,110;365,110])
add_line([sys,'/','segnali/onda quadra'],[140,85;105,85;105,50;130,50])
add_line([sys,'/','segnali/onda quadra'],[160,45;230,45;230,85;200,85])
add_line([sys,'/','segnali/onda quadra'],[50,40;130,40])
add_line([sys,'/','segnali/onda quadra'],[155,130;210,130;210,175;195,175])
add_line([sys,'/','segnali/onda quadra'],[135,175;100,175;100,135;125,135])
add_line([sys,'/','segnali/onda quadra'],[50,40;70,40;70,125;125,125])
add_line([sys,'/','segnali/onda quadra'],[160,45;280,45])
add_line([sys,'/','segnali/onda quadra'],[155,130;245,130;245,55;280,55])
set_param([sys,'/','segnali/onda quadra'],...
		'Mask Display','plot(0,0,100,100,[90,75,75,60,60,35,35,20,20,10],[20,20,80,80,20,20,80,80,20,20])',...
		'Mask Type','Pulse Generator')
set_param([sys,'/','segnali/onda quadra'],...
		'Mask Dialogue','Pulse Generator.|Pulse period (secs):|Pulse width:|Pulse height:|Pulse start time:')
set_param([sys,'/','segnali/onda quadra'],...
		'Mask Translate','Ts=@1; du=@2; ht=@3; stt=@4; ini=ones(length(ht),1); st1=rem(stt,Ts); st2=rem(stt+du,Ts);if(Ts<=1.2*du),ini=zeros(length(ht),1);end;')
set_param([sys,'/','segnali/onda quadra'],...
		'Mask Help','Pulse generator which ensures pulse\ntransitions are hit. Provides a vector of pulses when the height is entered as a vector.\nUnmask to see how it works.')
set_param([sys,'/','segnali/onda quadra'],...
		'Mask Entries','2\/1\/1\/0\/')


%     Finished composite block 'segnali/onda quadra'.

set_param([sys,'/','segnali/onda quadra'],...
		'ForeGround',3,...
		'position',[190,73,225,107])


%     Finished composite block 'segnali'.

set_param([sys,'/','segnali'],...
		'ForeGround',3,...
		'position',[40,9,70,61])
add_line(sys,[490,120;540,120])
add_line(sys,[570,115;650,115;650,185;550,185])
add_line(sys,[520,195;135,195;145,130])
add_line(sys,[170,125;205,125])
add_line(sys,[650,115;680,115])
add_line(sys,[290,125;335,125])
add_line(sys,[365,120;405,120])

drawnow

% Return any arguments.
if (nargin | nargout)
	% Must use feval here to access system in memory
	if (nargin > 3)
		if (flag == 0)
			eval(['[ret,x0,str,ts,xts]=',sys,'(t,x,u,flag);'])
		else
			eval(['ret =', sys,'(t,x,u,flag);'])
		end
	else
		[ret,x0,str,ts,xts] = feval(sys);
	end
else
	drawnow % Flash up the model and execute load callback
end
